/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import wjhk.jupload2.exception.JUploadEOFException;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.filedata.FileData;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.gui.filepanel.FilePanel;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.FilePreparationThread;
import wjhk.jupload2.upload.FileUploadManagerThread;
import wjhk.jupload2.upload.FileUploadThread;
import wjhk.jupload2.upload.FileUploadThreadFTP;
import wjhk.jupload2.upload.FileUploadThreadHTTP;
import wjhk.jupload2.upload.PacketConstructionThread;
import wjhk.jupload2.upload.UploadFileData;
import wjhk.jupload2.upload.UploadFilePacket;
import wjhk.jupload2.upload.helper.ProgressBarManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadManagerThreadImpl
extends Thread
implements FileUploadManagerThread {
    static final int FILE_PREPARATION_QUEUE_SIZE = 50;
    FilePanel filePanel = null;
    FilePreparationThread filePreparationThread = null;
    PacketConstructionThread packetConstructionThread = null;
    FileUploadThread fileUploadThread = null;
    ProgressBarManager progressBarManager;
    int nbSuccessfullyUploadedFiles = 0;
    boolean uploadFinished = false;
    boolean stop = false;
    JUploadException uploadException = null;
    JUploadPanel uploadPanel = null;
    UploadPolicy uploadPolicy = null;

    public FileUploadManagerThreadImpl(UploadPolicy uploadPolicy) throws JUploadException {
        super("FileUploadManagerThreadImpl thread");
        this.constructor(uploadPolicy, null);
    }

    FileUploadManagerThreadImpl(UploadPolicy uploadPolicy, FileUploadThread fileUploadThreadParam) throws JUploadException {
        super("FileUploadManagerThreadImpl test thread");
        this.constructor(uploadPolicy, fileUploadThreadParam);
    }

    private synchronized void constructor(UploadPolicy uploadPolicy, FileUploadThread fileUploadThreadParam) throws JUploadException {
        this.uploadPolicy = uploadPolicy;
        this.uploadPanel = uploadPolicy.getContext().getUploadPanel();
        this.filePanel = this.uploadPanel.getFilePanel();
        ArrayBlockingQueue<UploadFileData> preparedFileQueue = new ArrayBlockingQueue<UploadFileData>(this.filePanel.getFilesLength());
        BlockingQueue<UploadFilePacket> packetQueue = fileUploadThreadParam == null ? new ArrayBlockingQueue<UploadFilePacket>(this.filePanel.getFilesLength()) : fileUploadThreadParam.getPacketQueue();
        this.filePreparationThread = new FilePreparationThread(preparedFileQueue, this, this.uploadPolicy);
        this.packetConstructionThread = new PacketConstructionThread(preparedFileQueue, packetQueue, this, this.uploadPolicy);
        this.createUploadThread(packetQueue, fileUploadThreadParam);
        this.progressBarManager = new ProgressBarManager(this.uploadPolicy, this.filePreparationThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            this.uploadPolicy.displayDebug("Start of the FileUploadManagerThreadImpl", 5);
            this.progressBarManager.uploadIsStarted();
            this.filePreparationThread.start();
            this.packetConstructionThread.start();
            this.fileUploadThread.start();
            this.uploadPolicy.beforeUpload();
            this.uploadPanel.updateButtonState();
            while (this.fileUploadThread.isAlive() && !this.isUploadFinished()) {
                try {
                    this.uploadPolicy.displayDebug("Waiting for fileUploadThread to die", 10);
                    this.fileUploadThread.join();
                }
                catch (InterruptedException e) {
                    this.uploadPolicy.displayWarn("An InterruptedException occured in FileUploadManagerThreadImpl.run()");
                }
            }
            FileData[] fileDataArray = this.uploadPanel.getFilePanel().getFiles();
            for (int i = 0; i < fileDataArray.length; ++i) {
                if (!fileDataArray[i].isPreparedForUpload()) continue;
                fileDataArray[i].afterUpload();
            }
            this.uploadPanel.updateButtonState();
            this.uploadPolicy.getContext().showStatus("");
            this.uploadPolicy.getContext().getUploadPanel().getStatusLabel().setText("");
            if (this.getUploadException() != null) {
                this.uploadPolicy.sendDebugInformation("Error in Upload", this.getUploadException());
            } else if (this.isUploadStopped()) {
                this.uploadPolicy.displayInfo("Upload stopped by the user. " + this.nbSuccessfullyUploadedFiles + " file(s) uploaded in " + (int)((System.currentTimeMillis() - this.progressBarManager.getGlobalStartTime()) / 1000L) + " seconds. Average upload speed: " + (this.progressBarManager.getUploadDuration() > 0L ? (int)(this.progressBarManager.getNbUploadedBytes() / this.progressBarManager.getUploadDuration()) : 0) + " (kbytes/s)");
            } else {
                this.uploadPolicy.displayInfo("Upload finished normally. " + this.nbSuccessfullyUploadedFiles + " file(s) uploaded in " + (int)((System.currentTimeMillis() - this.progressBarManager.getGlobalStartTime()) / 1000L) + " seconds. Average upload speed: " + (this.progressBarManager.getUploadDuration() > 0L ? (int)(this.progressBarManager.getNbUploadedBytes() / this.progressBarManager.getUploadDuration()) : 0) + " (kbytes/s)");
                try {
                    this.uploadPolicy.afterUpload(this.getUploadException(), this.fileUploadThread.getResponseMsg());
                }
                catch (JUploadException e1) {
                    this.uploadPolicy.displayErr("error in uploadPolicy.afterUpload (JUploadPanel)", e1);
                }
            }
            this.progressBarManager.uploadIsFinished();
            try {
                FileUploadManagerThreadImpl.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this == this.uploadPanel.getFileUploadManagerThread()) {
                this.progressBarManager.clearBarContent();
                this.uploadPolicy.getContext().getUploadPanel().getStatusLabel().setText("");
            }
            this.uploadPolicy.displayDebug("End of the FileUploadManagerThreadImpl", 5);
        }
        catch (Exception e) {
            JUploadException jue = e instanceof JUploadException ? (JUploadException)e : new JUploadException(e);
            this.setUploadException(jue);
            this.stopUpload();
        }
        finally {
            this.uploadPanel.updateButtonState();
        }
    }

    @Override
    public synchronized void setUploadException(JUploadException uploadExceptionParam) {
        if (!this.isUploadStopped() || !(uploadExceptionParam instanceof JUploadEOFException)) {
            if (this.uploadException != null) {
                this.uploadPolicy.displayWarn("An exception has already been set in FileUploadManagerThreadImpl. The next one is just logged.");
            } else {
                this.uploadException = uploadExceptionParam;
            }
            String exceptionMsg = uploadExceptionParam.getCause() == null ? uploadExceptionParam.getMessage() : uploadExceptionParam.getCause().getMessage();
            String errMsg = this.uploadPolicy.getLocalizedString("errDuringUpload", new Object[0]) + "\n\n" + exceptionMsg;
            this.uploadPolicy.displayErr(errMsg, this.uploadException);
        }
    }

    @Override
    public JUploadException getUploadException() {
        return this.uploadException;
    }

    @Override
    public boolean isUploadFinished() {
        return this.uploadFinished || this.stop || this.uploadException != null;
    }

    @Override
    public boolean isUploadStopped() {
        return this.stop;
    }

    @Override
    public synchronized void nbBytesUploaded(long nbBytes, UploadFileData uploadFileData) throws JUploadException {
        this.progressBarManager.nbBytesUploaded(nbBytes, uploadFileData);
    }

    @Override
    public synchronized void setUploadStatus(UploadFilePacket uploadFilePacket, UploadFileData uploadFileData, int uploadStatus) throws JUploadException {
        this.progressBarManager.setUploadStatus(uploadFilePacket, uploadFileData, uploadStatus);
    }

    @Override
    public synchronized void stopUpload() {
        this.stop = true;
        this.uploadFinished = true;
        if (this.filePreparationThread != null && this.filePreparationThread.isAlive()) {
            this.filePreparationThread.interrupt();
        }
        if (this.packetConstructionThread != null && this.packetConstructionThread.isAlive()) {
            this.packetConstructionThread.interrupt();
        }
        if (this.fileUploadThread != null && this.fileUploadThread.isAlive()) {
            this.fileUploadThread.interrupt();
        }
        this.interrupt();
    }

    @Override
    public synchronized void anotherFileHasBeenSent(UploadFilePacket uploadFilePacket, UploadFileData newlyUploadedFileData) throws JUploadException {
        this.progressBarManager.anotherFileHasBeenSent(uploadFilePacket, newlyUploadedFileData);
    }

    @Override
    public synchronized void currentRequestIsFinished(UploadFilePacket uploadFilePacket) throws JUploadException {
        this.progressBarManager.setUploadStatus(uploadFilePacket, (UploadFileData)uploadFilePacket.get(uploadFilePacket.size() - 1), 5);
        for (UploadFileData fileData : uploadFilePacket) {
            this.filePanel.remove(fileData);
            ++this.nbSuccessfullyUploadedFiles;
        }
        if (!this.uploadFinished) {
            this.uploadFinished = this.nbSuccessfullyUploadedFiles == this.filePreparationThread.getNbFilesToSent();
        }
    }

    private synchronized void createUploadThread(BlockingQueue<UploadFilePacket> packetQueue, FileUploadThread fileUploadThreadParam) throws JUploadException {
        if (fileUploadThreadParam != null) {
            this.fileUploadThread = fileUploadThreadParam;
            fileUploadThreadParam.setFileUploadThreadManager(this);
        } else {
            try {
                this.fileUploadThread = this.uploadPolicy.getPostURL().substring(0, 4).equals("ftp:") ? new FileUploadThreadFTP(this.uploadPolicy, packetQueue, this) : new FileUploadThreadHTTP(this.uploadPolicy, packetQueue, this);
            }
            catch (JUploadException e1) {
                this.uploadPolicy.displayErr(e1);
            }
        }
    }
}

