/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.exception.JUploadIOException;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.DefaultFileUploadThread;
import wjhk.jupload2.upload.FileUploadManagerThread;
import wjhk.jupload2.upload.UploadFileData;
import wjhk.jupload2.upload.UploadFilePacket;
import wjhk.jupload2.upload.helper.ByteArrayEncoder;
import wjhk.jupload2.upload.helper.ByteArrayEncoderHTTP;
import wjhk.jupload2.upload.helper.HTTPConnectionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadThreadHTTP
extends DefaultFileUploadThread {
    private HTTPConnectionHelper connectionHelper = null;
    private HashMap<UploadFileData, ByteArrayEncoder> heads = null;
    private HashMap<UploadFileData, ByteArrayEncoder> tails = null;

    public FileUploadThreadHTTP(UploadPolicy uploadPolicy, BlockingQueue<UploadFilePacket> packetQueue, FileUploadManagerThread fileUploadManagerThread) {
        super("FileUploadThreadHTTP thread", packetQueue, uploadPolicy, fileUploadManagerThread);
        this.uploadPolicy.displayDebug("  Using " + this.getClass().getName(), 30);
        uploadPolicy.displayDebug("Upload done by using the " + this.getClass().getName() + " class", 30);
        this.setName("FileUploadThreadHTTP");
        this.connectionHelper = new HTTPConnectionHelper(uploadPolicy);
    }

    @Override
    void beforeRequest(UploadFilePacket packet) throws JUploadException {
        if (this.connectionHelper != null) {
            this.connectionHelper.dispose();
        }
        this.connectionHelper = new HTTPConnectionHelper(this.uploadPolicy);
        this.setAllHead(packet, this.connectionHelper.getBoundary());
        this.setAllTail(packet, this.connectionHelper.getBoundary());
    }

    @Override
    long getAdditionnalBytesForUpload(UploadFileData uploadFileData) throws JUploadIOException {
        return this.heads.get(uploadFileData).getEncodedLength() + this.tails.get(uploadFileData).getEncodedLength();
    }

    @Override
    void afterFile(UploadFileData uploadFileData) throws JUploadIOException {
        this.connectionHelper.append(this.tails.get(uploadFileData));
        this.uploadPolicy.displayDebug("--- filetail start (len=" + this.tails.get(uploadFileData).getEncodedLength() + "):", 70);
        this.uploadPolicy.displayDebug(this.quoteCRLF(this.tails.get(uploadFileData).getString()), 70);
        this.uploadPolicy.displayDebug("--- filetail end", 70);
    }

    @Override
    void beforeFile(UploadFilePacket uploadFilePacket, UploadFileData uploadFileData) throws JUploadException {
        try {
            this.connectionHelper.append(this.heads.get(uploadFileData).getEncodedByteArray());
            this.uploadPolicy.displayDebug("--- fileheader start (len=" + this.heads.get(uploadFileData).getEncodedLength() + "):", 70);
            this.uploadPolicy.displayDebug(this.quoteCRLF(this.heads.get(uploadFileData).getString()), 70);
            this.uploadPolicy.displayDebug("--- fileheader end", 70);
        }
        catch (Exception e) {
            throw new JUploadException(e);
        }
    }

    @Override
    void cleanAll() throws JUploadException {
    }

    @Override
    void cleanRequest() throws JUploadException {
        try {
            this.connectionHelper.dispose();
        }
        catch (JUploadIOException e) {
            this.uploadPolicy.displayErr(this.uploadPolicy.getLocalizedString("errDuringUpload", new Object[0]), e);
            throw e;
        }
    }

    @Override
    int finishRequest() throws JUploadException {
        if (this.uploadPolicy.getDebugLevel() > 100) {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        int status = this.connectionHelper.readHttpResponse();
        this.setResponseMsg(this.connectionHelper.getResponseMsg());
        this.setResponseBody(this.connectionHelper.getResponseBody());
        return status;
    }

    @Override
    void interruptionReceived() {
        try {
            ByteArrayEncoder bae;
            if (this.connectionHelper != null) {
                this.connectionHelper.dispose();
                this.connectionHelper = null;
            }
            if (this.heads != null) {
                for (UploadFileData uploadFileData : this.heads.keySet()) {
                    bae = this.heads.get(uploadFileData);
                    if (bae == null) continue;
                    bae.close();
                }
                this.heads = null;
            }
            if (this.tails != null) {
                for (UploadFileData uploadFileData : this.tails.keySet()) {
                    bae = this.tails.get(uploadFileData);
                    if (bae == null) continue;
                    bae.close();
                }
                this.tails = null;
            }
        }
        catch (Exception e) {
            this.uploadPolicy.displayWarn("Exception in " + this.getClass().getName() + ".interruptionReceived() (" + e.getClass().getName() + "): " + e.getMessage());
        }
    }

    @Override
    OutputStream getOutputStream() throws JUploadException {
        return this.connectionHelper.getOutputStream();
    }

    @Override
    void startRequest(long contentLength, boolean bChunkEnabled, int chunkPart, boolean bLastChunk) throws JUploadException {
        try {
            String chunkHttpParam = "jupart=" + chunkPart + "&jufinal=" + (bLastChunk ? "1" : "0");
            this.uploadPolicy.displayDebug("chunkHttpParam: " + chunkHttpParam, 30);
            URL url = new URL(this.uploadPolicy.getPostURL());
            if (bChunkEnabled) {
                url = null != url.getQuery() && !"".equals(url.getQuery()) ? new URL(url.toExternalForm() + "&" + chunkHttpParam) : new URL(url.toExternalForm() + "?" + chunkHttpParam);
            }
            this.connectionHelper.initRequest(url, "POST", bChunkEnabled, bLastChunk);
            ByteArrayEncoder formParams = this.getFormParamsForPostRequest(url);
            this.connectionHelper.append("Content-Type: multipart/form-data; boundary=").append(this.connectionHelper.getBoundary().substring(2)).append("\r\n");
            this.connectionHelper.append("Content-Length: ").append(String.valueOf(contentLength += (long)formParams.getEncodedLength())).append("\r\n");
            this.connectionHelper.append("\r\n");
            this.connectionHelper.append(formParams);
            this.connectionHelper.sendRequest();
            this.uploadPolicy.displayDebug("=== main header (len=" + this.connectionHelper.getByteArrayEncoder().getEncodedLength() + "):\n" + this.quoteCRLF(this.connectionHelper.getByteArrayEncoder().getString()), 70);
            this.uploadPolicy.displayDebug("=== main header end", 70);
        }
        catch (IOException e) {
            throw new JUploadIOException(e);
        }
        catch (IllegalArgumentException e) {
            throw new JUploadException(e);
        }
    }

    private final ByteArrayEncoder getFileHeader(UploadFileData uploadFileData, int numInCurrentUpload, String bound, int chunkPart) throws JUploadException {
        String form;
        String filenameEncoding = this.uploadPolicy.getFilenameEncoding();
        String mimetype = uploadFileData.getMimeType();
        String uploadFilename = uploadFileData.getUploadFilename(numInCurrentUpload);
        ByteArrayEncoderHTTP bae = new ByteArrayEncoderHTTP(this.uploadPolicy, bound);
        if (numInCurrentUpload == 0 && null != (form = this.uploadPolicy.getFormdata())) {
            bae.appendFormVariables(form);
        }
        uploadFileData.appendFileProperties(bae, numInCurrentUpload);
        bae.append(bound).append("\r\n");
        bae.append("Content-Disposition: form-data; name=\"");
        bae.append(uploadFileData.getUploadName(numInCurrentUpload)).append("\"; filename=\"");
        if (filenameEncoding == null) {
            bae.append(uploadFilename);
        } else {
            try {
                this.uploadPolicy.displayDebug("Encoded filename: " + URLEncoder.encode(uploadFilename, filenameEncoding), 70);
                bae.append(URLEncoder.encode(uploadFilename, filenameEncoding));
            }
            catch (UnsupportedEncodingException e) {
                this.uploadPolicy.displayWarn(e.getClass().getName() + ": " + e.getMessage() + " (in UploadFileData.getFileHeader)");
                bae.append(uploadFilename);
            }
        }
        bae.append("\"\r\n");
        bae.append("Content-Type: ").append(mimetype).append("\r\n");
        bae.append("\r\n");
        bae.close();
        return bae;
    }

    private final void setAllHead(UploadFilePacket packet, String bound) throws JUploadException {
        this.heads = new HashMap(packet.size());
        int numInCurrentUpload = 0;
        for (UploadFileData uploadFileData : packet) {
            this.heads.put(uploadFileData, this.getFileHeader(uploadFileData, numInCurrentUpload++, bound, -1));
        }
    }

    private final void setAllTail(UploadFilePacket packet, String bound) throws JUploadException {
        this.tails = new HashMap(packet.size());
        for (int i = 0; i < packet.size(); ++i) {
            ByteArrayEncoderHTTP bae = new ByteArrayEncoderHTTP(this.uploadPolicy, bound);
            bae.append("\r\n");
            if (this.uploadPolicy.getSendMD5Sum()) {
                bae.appendTextProperty("md5sum", ((UploadFileData)packet.get(i)).getMD5(), i);
            }
            if (i == packet.size() - 1) {
                bae.append(bound).append("--\r\n");
            }
            bae.close();
            this.tails.put((UploadFileData)packet.get(i), bae);
        }
    }

    private final ByteArrayEncoder getFormParamsForPostRequest(URL url) throws JUploadIOException {
        ByteArrayEncoderHTTP bae = new ByteArrayEncoderHTTP(this.uploadPolicy, this.connectionHelper.getBoundary());
        String query = url.getQuery();
        if (null != query) {
            String[] paramPairs;
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            for (String param : paramPairs = query.split("&")) {
                if (!param.contains("=")) continue;
                String[] oneParamArray = param.split("=");
                if (oneParamArray.length > 1) {
                    requestParameters.put(oneParamArray[0], oneParamArray[1]);
                    continue;
                }
                requestParameters.put(oneParamArray[0], "");
            }
            Set entrySet = requestParameters.entrySet();
            for (Map.Entry entry : entrySet) {
                bae.appendTextProperty((String)entry.getKey(), (String)entry.getValue(), -1);
            }
        }
        bae.close();
        return bae;
    }
}

