/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.upload.helper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.policies.UploadPolicy;
import wjhk.jupload2.upload.helper.HTTPConnectionHelper;

public class HttpConnect {
    private static final String HTTPCONNECT_DEFAULT_PROTOCOL = "HTTP/1.1";
    private UploadPolicy uploadPolicy;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Socket connect(URL url, Proxy proxy) throws NoSuchAlgorithmException, KeyManagementException, ConnectException, UnknownHostException, IOException, KeyStoreException, CertificateException, IllegalArgumentException, UnrecoverableKeyException {
        int port;
        boolean useProxy;
        Socket ret = null;
        String host = url.getHost();
        boolean bl = useProxy = proxy != null && proxy.type() != Proxy.Type.DIRECT;
        if (url.getProtocol().equals("https")) {
            int port2 = -1 == url.getPort() ? 443 : url.getPort();
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, new X509TrustManager[]{new TM()}, null);
            if (useProxy) {
                if (proxy.type() == Proxy.Type.HTTP) {
                    InetSocketAddress sa = (InetSocketAddress)proxy.address();
                    String proxyhost = sa.isUnresolved() ? sa.getHostName() : sa.getAddress().getHostAddress();
                    int proxyport = sa.getPort();
                    this.uploadPolicy.displayDebug("Using SSL socket, via HTTP proxy", 20);
                    Socket tsock = new Socket(proxyhost, proxyport);
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(tsock.getOutputStream()));
                    BufferedReader reader = new BufferedReader(new InputStreamReader(tsock.getInputStream()));
                    String hostport = host + ":" + port2;
                    String req = "CONNECT " + hostport + " HTTP/1.0\r\n\r\n";
                    writer.write(req);
                    writer.flush();
                    String res = reader.readLine();
                    String[] status = res.split(" ", 3);
                    if (status.length >= 2) {
                        if (status[1].startsWith("200")) return context.getSocketFactory().createSocket(tsock, url.getHost(), port2, true);
                    }
                    this.uploadPolicy.displayDebug("res: " + res, 10);
                    throw new ConnectException("proxy connection error");
                }
                if (proxy.type() != Proxy.Type.SOCKS) throw new ConnectException("Unkown proxy type " + (Object)((Object)proxy.type()));
                this.uploadPolicy.displayDebug("Using SSL socket, via SOCKS proxy", 20);
                Socket tsock = new Socket(proxy);
                tsock.connect(new InetSocketAddress(host, port2));
                return context.getSocketFactory().createSocket(tsock, host, port2, true);
            }
            this.uploadPolicy.displayDebug("Using SSL socket, direct connection", 20);
            return context.getSocketFactory().createSocket(host, port2);
        }
        int n = port = -1 == url.getPort() ? 80 : url.getPort();
        if (useProxy) {
            if (proxy.type() == Proxy.Type.HTTP) {
                InetSocketAddress sa = (InetSocketAddress)proxy.address();
                host = sa.isUnresolved() ? sa.getHostName() : sa.getAddress().getHostAddress();
                port = sa.getPort();
                this.uploadPolicy.displayDebug("Using non SSL socket, proxy=" + host + ":" + port, 20);
                return new Socket(host, port);
            }
            if (proxy.type() != Proxy.Type.SOCKS) throw new ConnectException("Unkown proxy type " + (Object)((Object)proxy.type()));
            this.uploadPolicy.displayDebug("Using non SSL socket, via SOCKS proxy", 20);
            Socket tsock = new Socket(proxy);
            tsock.connect(new InetSocketAddress(host, port));
            return tsock;
        }
        this.uploadPolicy.displayDebug("Using non SSL socket, direct connection", 20);
        return new Socket(host, port);
    }

    public Socket connect(URL url) throws NoSuchAlgorithmException, KeyManagementException, ConnectException, UnknownHostException, IOException, URISyntaxException, KeyStoreException, CertificateException, IllegalArgumentException, UnrecoverableKeyException {
        Proxy proxy = ProxySelector.getDefault().select(url.toURI()).get(0);
        return this.connect(url, proxy);
    }

    public String getProtocol() throws URISyntaxException, KeyManagementException, NoSuchAlgorithmException, UnknownHostException, KeyStoreException, CertificateException, IllegalArgumentException, UnrecoverableKeyException, IOException, JUploadException {
        Pattern pLocation;
        Matcher mLocation;
        String protocol = HTTPCONNECT_DEFAULT_PROTOCOL;
        URL url = new URL(this.uploadPolicy.getPostURL());
        this.uploadPolicy.displayDebug("Checking protocol with URL: " + url, 30);
        HTTPConnectionHelper connectionHelper = new HTTPConnectionHelper(url, "HEAD", false, true, this.uploadPolicy);
        connectionHelper.append("\r\n");
        this.uploadPolicy.displayDebug("Before sendRequest()", 30);
        connectionHelper.sendRequest();
        this.uploadPolicy.displayDebug("After sendRequest()", 30);
        connectionHelper.getOutputStream().flush();
        if (this.uploadPolicy.getDebugLevel() >= 80) {
            this.uploadPolicy.displayDebug("-------------------------------------------------------------------------", 80);
            this.uploadPolicy.displayDebug("-----------------   HEAD message sent (start)  --------------------------", 80);
            this.uploadPolicy.displayDebug("-------------------------------------------------------------------------", 80);
            this.uploadPolicy.displayDebug(connectionHelper.getByteArrayEncoder().getString(), 80);
            this.uploadPolicy.displayDebug("-------------------------------------------------------------------------", 80);
            this.uploadPolicy.displayDebug("-----------------   HEAD message sent (end) -----------------------------", 80);
            this.uploadPolicy.displayDebug("-------------------------------------------------------------------------", 80);
        }
        int status = connectionHelper.readHttpResponse();
        this.uploadPolicy.displayDebug("HEAD status: " + status, 30);
        String headers = connectionHelper.getResponseHeaders();
        Matcher m = Pattern.compile("^(HTTP/\\d\\.\\d)\\s(.*)\\s.*$", 8).matcher(headers);
        if (!m.find()) {
            this.uploadPolicy.displayErr("Unexpected HEAD response (can't find the protocol): will use the default one.");
        } else {
            protocol = m.group(1);
            this.uploadPolicy.displayDebug("HEAD protocol: " + protocol, 30);
        }
        Pattern pIIS = Pattern.compile("^Server: .*IIS*$", 8);
        Matcher mIIS = pIIS.matcher(headers);
        if (mIIS.find()) {
            try {
                this.uploadPolicy.setProperty("allowHttpPersistent", "false");
                this.uploadPolicy.displayWarn("allowHttpPersistent' forced to false, for IIS compatibility (in HttpConnect.getProtocol())");
            }
            catch (JUploadException e) {
                this.uploadPolicy.displayWarn("Can't set property 'allowHttpPersistent' to false, in HttpConnect.getProtocol()");
            }
        }
        if ((status == 301 || status == 302 || status == 303) && (mLocation = (pLocation = Pattern.compile("^Location: (.*)$", 8)).matcher(headers)).find()) {
            this.uploadPolicy.displayDebug("Location read: " + mLocation.group(1), 50);
            this.changePostURL(mLocation.group(1));
        }
        connectionHelper.dispose();
        return protocol;
    }

    private void changePostURL(String newLocation) throws JUploadException {
        String currentPostURL = this.uploadPolicy.getPostURL();
        Pattern pHostName = Pattern.compile("http://([^/]*)/.*");
        Matcher mOldPostURL = Pattern.compile("(.*)\\?(.*)").matcher(currentPostURL);
        String newPostURL = mOldPostURL.matches() ? newLocation + '?' + mOldPostURL.group(2) : newLocation;
        Matcher mHostOldPostURL = pHostName.matcher(currentPostURL);
        if (!mHostOldPostURL.matches()) {
            throw new JUploadException("[HttpConnect.changePostURL()] No host found in the old postURL !");
        }
        Matcher mHostNewLocation = pHostName.matcher(newLocation);
        if (!mHostNewLocation.matches()) {
            if (newLocation.startsWith("/")) {
                newPostURL = "http://" + mHostOldPostURL.group(1) + newPostURL;
            } else {
                Matcher mOldPostURLAllButFilename = Pattern.compile("(.*)/([^/]*)$").matcher(currentPostURL);
                if (!mOldPostURLAllButFilename.matches()) {
                    throw new JUploadException("[HttpConnect.changePostURL()] Can't find the filename in the URL !");
                }
                newPostURL = mOldPostURLAllButFilename.group(1) + "/" + newPostURL;
            }
        }
        this.uploadPolicy.setPostURL(newPostURL);
        this.uploadPolicy.displayInfo("postURL switched from " + currentPostURL + " to " + newPostURL);
    }

    public HttpConnect(UploadPolicy policy) {
        this.uploadPolicy = policy;
    }

    private final class TM
    implements X509TrustManager {
        private TM() {
        }

        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

