CREATE TABLE `tad_themes` (
  `theme_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT COMMENT '佈景編號',
  `theme_name` varchar(255) NOT NULL COMMENT '佈景名稱',
  `theme_type` varchar(255) NOT NULL COMMENT '版面類型',
  `lb_width` varchar(255) NOT NULL COMMENT '左區塊寬度',
  `rb_width` varchar(255) NOT NULL COMMENT '右區塊寬度',
  `clb_width` varchar(255) NOT NULL COMMENT '中左區塊寬度',
  `crb_width` varchar(255) NOT NULL COMMENT '中右區塊寬度',
  `lb_color` varchar(255) NOT NULL COMMENT '左區域背景色',
  `cb_color` varchar(255) NOT NULL COMMENT '中區域背景色',
  `rb_color` varchar(255) NOT NULL COMMENT '右區域背景色',
  `margin_top` varchar(255) NOT NULL COMMENT '上邊界',
  `margin_bottom` varchar(255) NOT NULL COMMENT '下邊界',
  `bg_img` varchar(255) NOT NULL COMMENT '背景圖',
  `logo_img` varchar(255) NOT NULL COMMENT 'logo圖',
  `bg_attachment` varchar(255) NOT NULL COMMENT '背景固定',
  `bg_color` varchar(255) NOT NULL COMMENT '背景顏色',
  `bg_position` varchar(255) NOT NULL COMMENT '背景位置',
  `bg_repeat` varchar(255) NOT NULL COMMENT '背景重複',
  `logo_top` smallint(5) unsigned NOT NULL COMMENT 'Logo離上方距離',
  `logo_right` smallint(5) unsigned NOT NULL COMMENT 'Logo離右邊距離',
  `logo_bottom` smallint(5) unsigned NOT NULL COMMENT 'Logo離下方距離',
  `logo_left` smallint(5) unsigned NOT NULL COMMENT 'Logo離左邊距離',
  `theme_enable` enum('1','0') NOT NULL COMMENT '使用狀況',
  `slide_width` varchar(255) NOT NULL COMMENT '佈景圖片寬度',
  `slide_height` varchar(255) NOT NULL COMMENT '佈景圖片高度',
  `font_size` varchar(255) NOT NULL COMMENT '文字大小',
  `font_color` varchar(255) NOT NULL COMMENT '文字顏色',
  `link_color` varchar(255) NOT NULL COMMENT '連結顏色',
  `hover_color` varchar(255) NOT NULL COMMENT '移致連結顏色',
  PRIMARY KEY (`theme_id`)
) ENGINE=MyISAM ;

CREATE TABLE `tad_themes_files_center` (
  `files_sn` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '檔案流水號',
  `col_name` varchar(255) NOT NULL COMMENT '欄位名稱',
  `col_sn` smallint(5) unsigned NOT NULL COMMENT '欄位編號',
  `sort` smallint(5) unsigned NOT NULL COMMENT '排序',
  `kind` enum('img','file') NOT NULL COMMENT '檔案種類',
  `file_name` varchar(255) NOT NULL COMMENT '檔案名稱',
  `file_type` varchar(255) NOT NULL COMMENT '檔案類型',
  `file_size` int(10) unsigned NOT NULL COMMENT '檔案大小',
  `description` text NOT NULL COMMENT '檔案說明',
  `counter` mediumint(8) unsigned NOT NULL COMMENT '下載人次',
  PRIMARY KEY (`files_sn`),
  UNIQUE KEY `col_name` (`col_name`,`col_sn`,`sort`)
)  ENGINE=MyISAM;

