<?php
/**
 * Ugm Wifi module
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting source code
 * which is considered copyrighted (c) material of the original comment or credit authors.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @copyright  The XOOPS Project http://sourceforge.net/projects/xoops/
 * @license    http://www.fsf.org/copyleft/gpl.html GNU public license
 * @package    Ugm Wifi
 * @since      2.5
 * @author     郭俊良
 * @version    $Id $
 **/

include_once "onInstall.php";
function xoops_module_update_ugm_wifi($module, $old_version) {
	global $xoopsDB;

	go_update();

	return true;
}

//拷貝目錄
function full_copy($source = "", $target = "") {
	if (is_dir($source)) {
		@mkdir($target);
		$d = dir($source);
		while (false !== ($entry = $d->read())) {
			if ($entry == '.' || $entry == '..') {
				continue;
			}

			$Entry = $source . '/' . $entry;
			if (is_dir($Entry)) {
				full_copy($Entry, $target . '/' . $entry);
				continue;
			}
			copy($Entry, $target . '/' . $entry);
		}
		$d->close();
	} else {
		copy($source, $target);
	}
}

function rename_win($oldfile, $newfile) {
	if (!rename($oldfile, $newfile)) {
		if (copy($oldfile, $newfile)) {
			unlink($oldfile);
			return true;
		}
		return false;
	}
	return true;
}

function delete_directory($dirname) {
	if (is_dir($dirname)) {
		$dir_handle = opendir($dirname);
	}

	if (!$dir_handle) {
		return false;
	}

	while ($file = readdir($dir_handle)) {
		if ($file != "." && $file != "..") {
			if (!is_dir($dirname . "/" . $file)) {
				unlink($dirname . "/" . $file);
			} else {
				delete_directory($dirname . '/' . $file);
			}

		}
	}
	closedir($dir_handle);
	rmdir($dirname);
	return true;
}
