
CREATE  PROCEDURAL LANGUAGE plpgsql;
SET search_path = public, pg_catalog;
CREATE OR REPLACE Function pg_catalog.pg_get_tabledef(text) RETURNS text
AS
$$
DECLARE
tabledef TEXT;
dotpos integer;
tablename text;
schemaname text;
prevcol text;
coltype text;
notnull1 boolean;
rec record;
oidcheck boolean;
BEGIN
dotpos:=strpos($1,'.');
if dotpos = 0 then
schemaname:='public';
tablename:=substr($1,dotpos+1);
else
schemaname:=substr($1,1,dotpos-1);
tablename:=substr($1,dotpos+1);
end if;
select relhasoids into oidcheck from pg_class, pg_namespace where pg_class.relnamespace=pg_namespace.oid and pg_namespace.nspname=schemaname and pg_class.relname=tablename and pg_class.relkind='r';
if not found then
tabledef:='Table Does not exists!';
return tabledef;
end if;
tabledef:= 'CREATE TABLE '|| schemaname||'.'||tablename;
for rec in SELECT a.attname as columnname ,pg_catalog.format_type(a.atttypid, a.atttypmod) as coltype1, (SELECT substring(pg_catalog.pg_get_expr(d.adbin, d.adrelid) for 128) FROM pg_catalog.pg_attrdef d WHERE d.adrelid = a.attrelid AND d.adnum = a.attnum AND a.atthasdef),a.attnotnull as notnull, a.attnum FROM pg_catalog.pg_attribute a WHERE a.attrelid = (select pg_class.oid from pg_class,pg_namespace where relname=tablename and pg_class.relnamespace=pg_namespace.oid and pg_namespace.nspname=schemaname) AND a.attnum > 0 AND NOT a.attisdropped ORDER BY a.attnum
loop
if prevcol is null then
tabledef:=tabledef||' (';
prevcol:=rec.columnname;
coltype:=rec.coltype1;
notnull1:=rec.notnull;
elsif notnull1 then
tabledef:=tabledef||' '||E'\n'||prevcol||' '||coltype||' NOT NULL ,';
prevcol:=rec.columnname;
coltype:=rec.coltype1;
notnull1:=rec.notnull;
else
tabledef:=tabledef||' '||E'\n'||prevcol||' '||coltype||' ,';
prevcol:=rec.columnname;
coltype:=rec.coltype1;
notnull1:=rec.notnull;
end if;
end loop;
if oidcheck = true and notnull1 = true then
tabledef:=tabledef||E'\n'||prevcol||' '||coltype||' NOT NULL ) WITH OIDS;';
elsif oidcheck = true and notnull1 = false then
tabledef:=tabledef||E'\n'||prevcol||' '||coltype||' NOT NULL ) WITH OIDS;';
elsif oidcheck=false and notnull1=true then
tabledef:=tabledef||E'\n'|| prevcol||' '||coltype||' NOT NULL ) WITHOUT OIDS;';
else
tabledef:=tabledef||E'\n'||prevcol||' '||coltype||' ) WITHOUT OIDS;';
end if;
return tabledef;
end;
$$ language plpgsql;


#
# Table structure for table `avatar`
#

CREATE TABLE avatar (
  avatar_id bigserial,
  avatar_file varchar(30) NOT NULL default '',
  avatar_name varchar(100) NOT NULL default '',
  avatar_mimetype varchar(30) NOT NULL default '',
  avatar_created int8 NOT NULL default '0',
  avatar_display int4 NOT NULL default '0',
  avatar_weight int4 NOT NULL default '0',
  avatar_type char(1) NOT NULL default '',
  PRIMARY KEY(avatar_id)
);
# --------------------------------------------------------

#
# Table structure for table `avatar_user_link`
#

CREATE TABLE avatar_user_link (
  avatar_id bigserial,
  user_id int4 NOT NULL default '0',
  PRIMARY KEY(avatar_id)
);
# --------------------------------------------------------

#
# Table structure for table `banner`
#

CREATE TABLE banner (
  bid bigserial,
  cid int4 NOT NULL default '0',
  imptotal int4 NOT NULL default '0',
  impmade  int4 NOT NULL default '0',
  clicks   int4 NOT NULL default '0',
  imageurl varchar(255) NOT NULL default '',
  clickurl varchar(255) NOT NULL default '',
  date int8 NOT NULL default '0',
  htmlbanner int2 NOT NULL default '0',
  htmlcode text,
  PRIMARY KEY(bid)
);
# --------------------------------------------------------

#
# Table structure for table `bannerclient`
#

CREATE TABLE bannerclient (
  cid serial,
  name varchar(60) NOT NULL default '',
  contact varchar(60) NOT NULL default '',
  email varchar(60) NOT NULL default '',
  login varchar(10) NOT NULL default '',
  passwd varchar(10) NOT NULL default '',
  extrainfo text,
  PRIMARY KEY(cid)
);
# --------------------------------------------------------

#
# Table structure for table `bannerfinish`
#

CREATE TABLE bannerfinish (
  bid serial,
  cid int4 NOT NULL default '0',
  impressions int4 NOT NULL default '0',
  clicks int4 NOT NULL default '0',
  datestart int8 NOT NULL default '0',
  dateend int8  NOT NULL default '0',
  PRIMARY KEY(bid)
);
# --------------------------------------------------------

#
# Table structure for table `block_module_link`
#

CREATE TABLE block_module_link (
  block_id int4 NOT NULL default '0',
  module_id int4 NOT NULL default '0'
);
# --------------------------------------------------------

#
# Table structure for table `comments`
#

CREATE TABLE xoopscomments (
  com_id serial,
  com_pid int4 NOT NULL default '0',
  com_rootid int4 NOT NULL default '0',
  com_modid int4 NOT NULL default '0',
  com_itemid int4 NOT NULL default '0',
  com_icon varchar(25) NOT NULL default '',
  com_created int8 NOT NULL default '0',
  com_modified int8 NOT NULL default '0',
  com_uid int4 NOT NULL default '0',
  com_ip varchar(15) NOT NULL default '',
  com_title varchar(255) NOT NULL default '',
  com_text text,
  com_sig int2 NOT NULL default '0',
  com_status int2 NOT NULL default '0',
  com_exparams varchar(255) NOT NULL default '',
  dohtml int2 NOT NULL default '0',
  dosmiley int2 NOT NULL default '0',
  doxcode int2 NOT NULL default '0',
  doimage int2 NOT NULL default '0',
  dobr int2 NOT NULL default '0',
  PRIMARY KEY(com_id)
);
# --------------------------------------------------------

# RMV-NOTIFY
# Table structure for table `notifications`
#

CREATE TABLE xoopsnotifications (
  not_id serial,
  not_modid int4 NOT NULL default '0',
  not_itemid int4 NOT NULL default '0',
  not_category varchar(30) NOT NULL default '',
  not_event varchar(30) NOT NULL default '',
  not_uid int4 NOT NULL default '0',
  not_mode int2 NOT NULL default 0,
  PRIMARY KEY(not_id)
);
# --------------------------------------------------------

#
# Table structure for table `config`
#

CREATE TABLE config (
  conf_id serial,
  conf_modid int4 NOT NULL default '0',
  conf_catid int4 NOT NULL default '0',
  conf_name varchar(25) NOT NULL default '',
  conf_title varchar(255) NOT NULL default '',
  conf_value text,
  conf_desc varchar(255) NOT NULL default '',
  conf_formtype varchar(15) NOT NULL default '',
  conf_valuetype varchar(10) NOT NULL default '',
  conf_order int4 NOT NULL default '0',
  PRIMARY KEY(conf_id)
);
# --------------------------------------------------------

#
# Table structure for table `configcategory`
#

CREATE TABLE configcategory (
  confcat_id serial,
  confcat_name varchar(255) NOT NULL default '',
  confcat_order int4 NOT NULL default '0',
  PRIMARY KEY(confcat_id)
);
# --------------------------------------------------------

#
# Table structure for table `configoption`
#

CREATE TABLE configoption (
  confop_id serial,
  confop_name varchar(255) NOT NULL default '',
  confop_value varchar(255) NOT NULL default '',
  conf_id int4 NOT NULL default '0',
  PRIMARY KEY(confop_id)
);
# --------------------------------------------------------

#
# Table structure for table `groups`
#

CREATE TABLE groups (
  groupid serial,
  name varchar(50) NOT NULL default '',
  description text,
  group_type varchar(10) NOT NULL default '',
  PRIMARY KEY(groupid)
);
# --------------------------------------------------------

#
# Table structure for table `group_permission`
#

CREATE TABLE group_permission (
  gperm_id bigserial,
  gperm_groupid int4 NOT NULL default '0',
  gperm_itemid int4 NOT NULL default '0',
  gperm_modid int4 NOT NULL default '0',
  gperm_name varchar(50) NOT NULL default '',
  PRIMARY KEY(gperm_id)
);
# --------------------------------------------------------


#
# Table structure for table `groups_users_link`
#

CREATE TABLE groups_users_link (
  linkid serial,
  groupid int4 NOT NULL default '0',
  uid int4 NOT NULL default '0',
  PRIMARY KEY(linkid)
);
# --------------------------------------------------------

#
# Table structure for table `image`
#

CREATE TABLE image (
  image_id  serial,
  image_name varchar(30) NOT NULL default '',
  image_nicename varchar(255) NOT NULL default '',
  image_mimetype varchar(30) NOT NULL default '',
  image_created int8 NOT NULL default '0',
  image_display int2 NOT NULL default '0',
  image_weight int4 NOT NULL default '0',
  imgcat_id int4 NOT NULL default '0',
  PRIMARY KEY(image_id)
);
# --------------------------------------------------------

#
# Table structure for table `imagebody`
#

CREATE TABLE imagebody (
  image_id int4 NOT NULL default '0',
  image_body bytea,
  PRIMARY KEY(image_id)
);
# --------------------------------------------------------

#
# Table structure for table `imagecategory`
#

CREATE TABLE imagecategory (
  imgcat_id serial,
  imgcat_name varchar(100) NOT NULL default '',
  imgcat_maxsize int8 NOT NULL default '0',
  imgcat_maxwidth int4 NOT NULL default '0',
  imgcat_maxheight int4 NOT NULL default '0',
  imgcat_display int2 NOT NULL default '0',
  imgcat_weight int2 NOT NULL default '0',
  imgcat_type char(1) NOT NULL default '',
  imgcat_storetype varchar(5) NOT NULL default '',
  PRIMARY KEY(imgcat_id)
);
# --------------------------------------------------------


#
# Table structure for table `imgset`
#

CREATE TABLE imgset (
  imgset_id serial,
  imgset_name varchar(50) NOT NULL default '',
  imgset_refid int4 NOT NULL default '0',
  PRIMARY KEY(imgset_id)
);
# --------------------------------------------------------

#
# Table structure for table `imgset_tplset_link`
#

CREATE TABLE imgset_tplset_link (
  imgset_id int4 NOT NULL default '0',
  tplset_name varchar(50) NOT NULL default ''
);
# --------------------------------------------------------

#
# Table structure for table `imgsetimg`
#

CREATE TABLE imgsetimg (
  imgsetimg_id serial,
  imgsetimg_file varchar(50) NOT NULL default '',
  imgsetimg_body bytea,
  imgsetimg_imgset int4 NOT NULL default '0',
  PRIMARY KEY(imgsetimg_id)
);
# --------------------------------------------------------

#
# Table structure for table `modules`
#

CREATE TABLE modules (
  mid serial,
  name varchar(150) NOT NULL default '',
  version int4 NOT NULL default '100',
  last_update int8 NOT NULL default '0',
  weight int4 NOT NULL default '0',
  isactive int2 NOT NULL default '0',
  dirname varchar(25) NOT NULL default '',
  hasmain int2 NOT NULL default '0',
  hasadmin int2 NOT NULL default '0',
  hassearch int2 NOT NULL default '0',
  hasconfig int2 NOT NULL default '0',
  hascomments int2 NOT NULL default '0',
  hasnotification int2 NOT NULL default '0',
  PRIMARY KEY(mid)
);
# --------------------------------------------------------

#
# Table structure for table `newblocks`
#

CREATE TABLE newblocks (
  bid bigserial,
  mid int4 NOT NULL default '0',
  func_num int4 NOT NULL default '0',
  options varchar(255) NOT NULL default '',
  name varchar(150) NOT NULL default '',
  title varchar(255) NOT NULL default '',
  content text,
  side int2 NOT NULL default '0',
  weight int4 NOT NULL default '0',
  visible int2 NOT NULL default '0',
  block_type char(1) NOT NULL default '',
  c_type char(1) NOT NULL default '',
  isactive int2 NOT NULL default '0',
  dirname varchar(50) NOT NULL default '',
  func_file varchar(50) NOT NULL default '',
  show_func varchar(50) NOT NULL default '',
  edit_func varchar(50) NOT NULL default '',
  template varchar(50) NOT NULL default '',
  bcachetime int8 NOT NULL default '0',
  last_modified int8 NOT NULL default '0',
  PRIMARY KEY(bid)
);
# --------------------------------------------------------

#
# Table structure for table `online`
#

CREATE TABLE online (
  online_uid int4 NOT NULL default '0',
  online_uname varchar(25) NOT NULL default '',
  online_updated int8 NOT NULL default '0',
  online_module int4 NOT NULL default '0',
  online_ip varchar(15) NOT NULL default ''
);
# --------------------------------------------------------

#
# Table structure for table `priv_msgs`
#

CREATE TABLE priv_msgs (
  msg_id serial,
  msg_image varchar(100) default NULL,
  subject varchar(255) NOT NULL default '',
  from_userid int4 NOT NULL default '0',
  to_userid int4 NOT NULL default '0',
  msg_time int8 NOT NULL default '0',
  msg_text text,
  read_msg int2 NOT NULL default '0',
  from_delete int2		      NOT NULL default '1',
  from_save   int2		      NOT NULL default '0',
  to_delete   int2		      NOT NULL default '0',
  to_save     int2                  NOT NULL default '0',
  PRIMARY KEY(msg_id)
);
# --------------------------------------------------------

#
# Table structure for table `ranks`
#

CREATE TABLE ranks (
  rank_id serial,
  rank_title varchar(50) NOT NULL default '',
  rank_min int4 NOT NULL default '0',
  rank_max int4 NOT NULL default '0',
  rank_special int2 NOT NULL default '0',
  rank_image varchar(255) default NULL,
  PRIMARY KEY(rank_id)
);
# --------------------------------------------------------

#
# Table structure for table `session`
#

CREATE TABLE session (
  sess_id varchar(32) NOT NULL default '',
  sess_updated int8 NOT NULL default '0',
  sess_ip varchar(15) NOT NULL default '',
  sess_data text
);
# --------------------------------------------------------

#
# Table structure for table `smiles`
#

CREATE TABLE smiles (
  id serial,
  code varchar(50) NOT NULL default '',
  smile_url varchar(100) NOT NULL default '',
  emotion varchar(75) NOT NULL default '',
  display int2 NOT NULL default '0',
  PRIMARY KEY(id)
);
# --------------------------------------------------------

#
# Table structure for table `tplset`
#

CREATE TABLE tplset (
  tplset_id bigserial,
  tplset_name varchar(50) NOT NULL default '',
  tplset_desc varchar(255) NOT NULL default '',
  tplset_credits text,
  tplset_created int8 NOT NULL default '0',
  PRIMARY KEY(tplset_id)
);
# --------------------------------------------------------

#
# Table structure for table `tplfile`
#

CREATE TABLE tplfile (
  tpl_id serial,
  tpl_refid int4 NOT NULL default '0',
  tpl_module varchar(25) NOT NULL default '',
  tpl_tplset varchar(50) NOT NULL default '',
  tpl_file varchar(50) NOT NULL default '',
  tpl_desc varchar(255) NOT NULL default '',
  tpl_lastmodified int8 NOT NULL default '0',
  tpl_lastimported int8 NOT NULL default '0',
  tpl_type varchar(20) NOT NULL default '',
  PRIMARY KEY(tpl_id)
);
# --------------------------------------------------------

#
# Table structure for table `tplsource`
#

CREATE TABLE tplsource (
  tpl_id int4 NOT NULL default '0',
  tpl_source text
);
# --------------------------------------------------------

# Table structure for table `users`
#

CREATE TABLE users (
  uid serial,
  name varchar(60) NOT NULL default '',
  uname varchar(25) NOT NULL default '',
  email varchar(60) NOT NULL default '',
  url varchar(100) NOT NULL default '',
  user_avatar varchar(30) NOT NULL default 'blank.gif',
  user_regdate int8 NOT NULL default '0',
  user_icq varchar(15) NOT NULL default '',
  user_from varchar(100) NOT NULL default '',
  user_sig text,
  user_viewemail int2 NOT NULL default '0',
  actkey varchar(8) NOT NULL default '',
  user_aim varchar(18) NOT NULL default '',
  user_yim varchar(25) NOT NULL default '',
  user_msnm varchar(100) NOT NULL default '',
  pass varchar(32) NOT NULL default '',
  posts int4 NOT NULL default '0',
  attachsig int2 NOT NULL default '0',
  rank int4 NOT NULL default '0',
  level int4 NOT NULL default '1',
  theme varchar(100) NOT NULL default '',
  timezone_offset NUMERIC(3,1) NOT NULL default '0.0',
  last_login int8 NOT NULL default '0',
  umode varchar(10) NOT NULL default '',
  uorder int2 NOT NULL default '0',
  notify_method int2 NOT NULL default '1',
  notify_mode int2 NOT NULL default '0',
  user_occ varchar(100) NOT NULL default '',
  bio text,
  user_intrest varchar(150) NOT NULL default '',
  user_mailok int2 NOT NULL default '1',
  user_connect int4 NOT NULL default 0,
  
  PRIMARY KEY(uid)
);
# --------------------------------------------------------

#
# Table structure for table `cache_model`
#

CREATE TABLE cache_model (
  cache_key     varchar(64)     NOT NULL default '',
  cache_expires int8            NOT NULL default '0',
  cache_data    text
);
# --------------------------------------------------------

