<?php
/**
 * Installer main english strings declaration file
 *
 * @copyright   The XOOPS project http://www.xoops.org/
 * @license     http://www.fsf.org/copyleft/gpl.html GNU General Public License (GPL)
 * @package     installer
 * @since       2.3.0
 * @author      Haruki Setoyama  <haruki@planewave.org>
 * @author      Kazumi Ono <webmaster@myweb.ne.jp>
 * @author      Skalpa Keo <skalpa@xoops.org>
 * @author      Taiwen Jiang <phppp@users.sourceforge.net>
 * @author      dugris <dugris@frxoops.org>
 * @version     $Id: install.php 3768 2009-10-23 08:37:41Z wishcraft $
 */

define( "SHOW_HIDE_HELP", "显示/隐藏 说明信息" );

// License
define('LICENSE_NOT_WRITEABLE', '通用公共许可证 %s，<br/><font style="colour:#ff0000">请设定 ../include/license.php 属性为“可写”</font>');
define('LICENSE_IS_WRITEABLE', '通用公共许可证 %s');

// Configuration check page
define( "SERVER_API", "Server API" );
define( "PHP_EXTENSION", "%s 扩展组件" );
define( "CHAR_ENCODING", "字符集编码" );
define( "XML_PARSING", "XML parsing" );
define( "REQUIREMENTS", "基本需求" );
define( "_PHP_VERSION", "PHP 版本" );
define( "RECOMMENDED_SETTINGS", "建议设定" );
define( "RECOMMENDED_EXTENSIONS", "建议启用的扩展组件" );
define( "SETTING_NAME", "设定名称" );
define( "RECOMMENDED", "推荐" );
define( "CURRENT", "目前" );
define( "RECOMMENDED_EXTENSIONS_MSG", "这些延伸套件不是一般用户必须安装和启用的，但是有些功能需要这些扩展组件才能使用（例如多字节语言或 RSS 支持等），因此，推荐安装和启用这些扩展组件。" );
define( "NONE", "无" );
define( "SUCCESS", "完成" );
define( "WARNING", "注意" );
define( "FAILED", "失败" );

// Titles (main and pages)
define( "XOOPS_INSTALL_WIZARD", "XOOPS 安装向导" );

define( "LANGUAGE_SELECTION", "选择语言" );
define( "LANGUAGE_SELECTION_TITLE", "选择语言");        // L128
define( "INTRODUCTION", "介绍" );
define( "INTRODUCTION_TITLE", "欢迎使用 XOOPS 安装向导，请按提示进行安装。" );        // L0
define( "CONFIGURATION_CHECK", "设定检查" );
define( "CONFIGURATION_CHECK_TITLE", "检查你的服务器设定" );
define( "PATHS_SETTINGS", "路径设定" );
define( "PATHS_SETTINGS_TITLE", "路径设定" );
define( "DATABASE_CONNECTION", "数据库连接设定" );
define( "DATABASE_CONNECTION_TITLE", "数据库连接设定" );
define( "DATABASE_CONFIG", "数据库设定" );
define( "DATABASE_CONFIG_TITLE", "数据库设定" );
define( "CONFIG_SAVE", "储存设定" );
define( "CONFIG_SAVE_TITLE", "储存设定" );
define( "TABLES_CREATION", "建立数据表" );
define( "TABLES_CREATION_TITLE", "数据表建立" );
define( "INITIAL_SETTINGS", "初始设定" );
define( "INITIAL_SETTINGS_TITLE", "请输入初始设定" );
define( "DATA_INSERTION", "添加数据" );
define( "DATA_INSERTION_TITLE", "保存数据到资料库" );
define( "WELCOME", "欢迎使用 XOOPS" );
define( "WELCOME_TITLE", "欢迎进入 XOOPS 网站" );        // L0


// Settings (labels and help text)
define( "XOOPS_PATHS", "XOOPS 物理路径" );
define( "XOOPS_URLS", "XOOPS 虚拟路径" );

define("XOOPS_ROOT_PATH_LABEL","XOOPS 实际路径：");
define("XOOPS_ROOT_PATH_HELP","XOOPS 根目录的绝对物理路径，结尾不要加'/'");

define( "XOOPS_LIB_PATH_LABEL", "XOOPS 公用类库（library directory）" );
define( "XOOPS_LIB_PATH_HELP", "XOOPS 公用类库（library directory）的绝对物理路径，结尾不要加'/'。安全起见，建议将该资料夹转移到 " . XOOPS_ROOT_PATH_LABEL . " 以外。");
define( "XOOPS_DATA_PATH_LABEL", "XOOPS 数据文件" );
define( "XOOPS_DATA_PATH_HELP", "XOOPS 数据文件（属性可写）的绝对物理路径，结尾不要加'/'。安全起见，建议将该目录转移到 " . XOOPS_ROOT_PATH_LABEL . "之外。" );

define( "XOOPS_URL_LABEL", "XOOPS 虚拟路径(URL)：" ); // L56
define( "XOOPS_URL_HELP", "造访（ XOOPS ）网站的网址，结尾不要加'/'" ); // L58

define( "LEGEND_CONNECTION", "数据库服务器连接配置" );
define( "LEGEND_DATABASE", "数据库" ); // L51

define( "DB_HOST_LABEL", "数据库主机名称：" );    // L27
define( "DB_HOST_HELP",  "如果不确定，请使用 <em>localhost</em>。"); // L67
define( "DB_USER_LABEL", "数据库用户帐号：" );    // L28
define( "DB_USER_HELP",  "用户登入数据库主机并创建数据库的帐号。"); // L65
define( "DB_PASS_LABEL", "数据库用户密码：" );    // L52
define( "DB_PASS_HELP",  "与数据库用户帐号对应的密码。"); // L68
define( "DB_NAME_LABEL", "数据库名称：" );    // L29
define( "DB_NAME_HELP",  "用于安装 XOOPS 的数据库名称，如果不存在，程序将自动创建。"); // L64
define( "DB_CHARSET_LABEL", "数据库字符集" );
define( "DB_CHARSET_HELP",  "MySQL 支援字符集设置，从而可以采用恰当的规则用于数据库保存和内容比较。");
define( "DB_COLLATION_LABEL", "数据库连接校对" );
define( "DB_COLLATION_HELP",  "数据库连接校对是用于字符比较的一套规则。");
define( "DB_PREFIX_LABEL", "数据表前置字串：" );    // L30
define( "DB_PREFIX_HELP",  "用于建立数据表时候的表前置字串，如果不确定，请保持默认。"); // L63
define( "DB_PCONNECT_LABEL", "数据库持续连接：" );    // L54
define( "DB_PCONNECT_HELP",  "建议虚拟主机用户不要选取。"); // L69
define("DB_DATABASE_LABEL","选择要使用的数据库类型");

define( "LEGEND_ADMIN_ACCOUNT", "管理员帐号设定" );
define("ADMIN_LOGIN_LABEL","网站管理员帐号：");
define("ADMIN_EMAIL_LABEL","网站管理员邮件：");
define("ADMIN_PASS_LABEL","网站管理员密码：");
define("ADMIN_CONFIRMPASS_LABEL","确认管理员密码：");

// Buttons
define( "BUTTON_PREVIOUS", "上一步" ); // L42
define( "BUTTON_NEXT", "下一步" ); // L47

// Messages
define( "XOOPS_FOUND", "%s 检测正确" );
define( "CHECKING_PERMISSIONS", "确认文件和目录权限…" ); // L82
define( "IS_NOT_WRITABLE", "目录 %s 属性只读" ); // L83
define( "IS_WRITABLE", "目录 %s 属性可写" ); // L84

define( "XOOPS_PATH_FOUND", "路径检测正确" );

define( "READY_CREATE_TABLES", "没有搜寻到数据表。<br />安装程序将会创建 XOOPS 系统所需的数据表<br />点选 <em>下一步</em> 执行此操作。" );
define( "XOOPS_TABLES_FOUND", "数据表已存在。<br />点选 <em>下一步</em> 继续进行安装" ); // L131
define( "XOOPS_TABLES_CREATED", "XOOPS 系统数据表新建成功。<br />点选 <em>下一步</em> 继续进行安装。" );
define( "READY_INSERT_DATA", "安装程序将会添加初始数据到数据库中。" );
define( "READY_SAVE_MAINFILE", "安装程序将会把指定的设置保存到 <em>mainfile.php</em>中。<br />点选 <em>下一步</em> 执行保存。" );
define( "SAVED_MAINFILE", "保存设置到 mainfile.php 中" );
define( "SAVED_MAINFILE_MSG", "XOOPS安装程序将会把指定的设置保存到 <em>mainfile.php</em> 及 <em>secure.php</em> 档案中。 点选 <em>下一步</em> 继续进行安装。" );
define( "DATA_ALREADY_INSERTED", "数据库中已有数据。<br />点击 <em>下一步</em> 继续进行安装。" );
define( "DATA_INSERTED", "添加初始数据到数据库中。<br />点击 <em>下一步</em> 继续进行安装。" );


// %s is database name
define( "DATABASE_CREATED", "数据库 %s 创建成功！" ); // L43
// %s is table name
define( "TABLE_NOT_CREATED", "无法建立数据表 %s" ); // L118
define( "TABLE_CREATED", "数据表 %s 创建成功 " ); // L45
define( "ROWS_INSERTED", "成功添加 %d 条记录到数据表 %s 中" ); // L119
define( "ROWS_FAILED", " 无法添加 %d 条数据到数据表 %s 中" ); // L120
define( "TABLE_ALTERED", "数据表 %s 更新成功 "); // L133
define( "TABLE_NOT_ALTERED", "数据表 %s 更新失败"); // L134
define( "TABLE_DROPPED", "数据表 %s 删除成功 "); // L163
define( "TABLE_NOT_DROPPED", "数据表 %s 删除失败"); // L164

// Error messages
define( "ERR_COULD_NOT_ACCESS", "无法读取指定目录，请检查是否存在并且设定属性为可读。" );
define( "ERR_NO_XOOPS_FOUND", "无法找到指定的目录。" );
define( "ERR_INVALID_EMAIL", "无效的电子邮件" ); // L73
define( "ERR_REQUIRED", "必填信息。" ); // L41
define( "ERR_PASSWORD_MATCH", "两次输入的密码不一致。" );
define( "ERR_NEED_WRITE_ACCESS", "下列目录属性必须为可读写：<br />(UNIX/LINUX 系统设定为 666、MacOS 系统设定为 777、WinOS 系统去掉只读属性)。" );
define( "ERR_NO_DATABASE", "无法创建数据库，请联系服务器管理员查询详细讯息。" ); // L31
define( "ERR_NO_DBCONNECTION", "无法连接到数据库服务器。" ); // L106
define( "ERR_WRITING_CONSTANT", "%s 设置失败。" ); // L122

define( "ERR_COPY_MAINFILE", "无法将 mainfile.dist.php 的内容复制到 mainfile.php 中" );
define( "ERR_WRITE_MAINFILE", "无法写入 mainfile.php。请检查文件权限后重试。");
define( "ERR_READ_MAINFILE", "无法读取 mainfile.php。" );

define( "ERR_INVALID_DBCHARSET", "字符集 '%s' 不支援。" );
define( "ERR_INVALID_DBCOLLATION", "连结校对 '%s' 不支援。" );
define( "ERR_CHARSET_NOT_SET", "未能设定 XOOPS 数据库的缺省字符集。" );


define("_INSTALL_CHARSET", "UTF-8");

define( "SUPPORT", "技术支持");

define( "LOGIN", "验证");
define( "LOGIN_TITLE", "验证");
define( "USER_LOGIN", "管理员登录" );
define( "USERNAME", "用户名 :");
define( "PASSWORD", "密码 :");

define( "ICONV_CONVERSION", "字符集转换");
define( "ZLIB_COMPRESSION", "zlib压缩");
define( "IMAGE_FUNCTIONS", "图形函数");
define( "IMAGE_METAS", "图像元数据（exif）");
define( "FILTER_FUNCTIONS", "筛选功能");

define( "ADMIN_EXIST", "管理员帐号已存在，<br />点选 <strong>下一步</strong> 进行下一步骤");

define( "CONFIG_SITE", "站点设定" );
define( "CONFIG_SITE_TITLE", "站点设定" );
define( "MODULES", "模块安装" );
define( "MODULES_TITLE", "模块安装" );
define( "THEME", "选择主题" );
define( "THEME_TITLE", "选择网站默认风格" );

define( "INSTALLED_MODULES", "以下模块已安装<br />请点击 <strong>下一步</strong> 继续安装");
define( "NO_MODULES_FOUND", "没有找到模块<br />请点击 <strong>下一步</strong> 继续安装");
define( "NO_INSTALLED_MODULES", "没有安装模块<br />请点击 <strong>下一步</strong> 继续安装");

define( "THEME_NO_SCREENSHOT", "没有找到缩略图");

define( "IS_VALOR", " => ");

// password message
define( "PASSWORD_LABEL", "密码强度：");
define( "PASSWORD_DESC", "密码不能为空");
define( "PASSWORD_GENERATOR", "密码产生器");
define( "PASSWORD_GENERATE", "生成");
define( "PASSWORD_COPY", "复制");

define( "PASSWORD_VERY_WEAK", "非常弱");
define( "PASSWORD_WEAK", "弱");
define( "PASSWORD_BETTER", "一般");
define( "PASSWORD_MEDIUM", "中等");
define( "PASSWORD_STRONG", "强");
define( "PASSWORD_STRONGEST", "非常强");
?>
